window.onload = function() {
    document.getElementById("floodButton").addEventListener("click", flood);
}

function flood() {
    let code = document.getElementById("code").value
    let name = document.getElementById("name").value
    let number = document.getElementById("number").value

    if (code && name && number) {
        if (name.length <= 12) {
            chrome.storage.sync.set({
                "name": name
            }, function() {
                for (var i = 0; i < number; i++) {
                    chrome.tabs.create({
                        "url": ("https://kahoot.it?pin="+code+"&refer_method=link"),
                        "active": false
                    }, func = tab => {
                        chrome.scripting.executeScript({ target: { tabId: tab.id }, files: ['autojoin.js'] });
                        chrome.tabs.update(tab.id, {
                            active: true,
                        }); 
                    });
                }
                document.getElementById("container").innerHTML = "<h1>Flooded Successfully</h1><p><strong>Press backspace on each tab to activate each bot.</strong><br>Keep the tabs open to ensure that the users stay in the Kahoot game.</p>";
            });
        } else {
            alert("Bot name must be no longer than 12 characters due to Kahoot limit.");
        }
    } else {
        alert("Please fill out all fields.");
    }
}
//,function(tab) {
//chrome.debugger.attach({ tabId: tab.id }, "1.0");
//chrome.debugger.sendCommand({ tabId: tabs[1].id }, 'Input.dispatchKeyEvent', { type: 'keyUp', windowsVirtualKeyCode: 8, nativeVirtualKeyCode: 8, macCharCode: 8 });
//chrome.debugger.sendCommand({ tabId: tabs[1].id }, 'Input.dispatchKeyEvent', { type: 'keyDown', windowsVirtualKeyCode: 8, nativeVirtualKeyCode: 8, macCharCode: 8 });
//chrome.debugger.detach({ tabId: tabs[1].id });
//}